/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.sql.init.dependency;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.sql.init.dependency.DatabaseInitializerDetector;
import org.springframework.boot.sql.init.dependency.DependsOnDatabaseInitializationDetector;
import org.springframework.boot.util.Instantiator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class DatabaseInitializationDependencyConfigurer
implements ImportBeanDefinitionRegistrar {
    private final Environment environment;

    DatabaseInitializationDependencyConfigurer(Environment environment2) {
        this.environment = environment2;
    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        String name = DependsOnDatabaseInitializationPostProcessor.class.getName();
        if (!registry.containsBeanDefinition(name)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DependsOnDatabaseInitializationPostProcessor.class, this::createDependsOnDatabaseInitializationPostProcessor);
            registry.registerBeanDefinition(name, builder.getBeanDefinition());
        }
    }

    private DependsOnDatabaseInitializationPostProcessor createDependsOnDatabaseInitializationPostProcessor() {
        return new DependsOnDatabaseInitializationPostProcessor(this.environment);
    }

    static class DependsOnDatabaseInitializationPostProcessor
    implements BeanFactoryPostProcessor {
        private final Environment environment;

        DependsOnDatabaseInitializationPostProcessor(Environment environment2) {
            this.environment = environment2;
        }

        @Override
        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            BeanDefinition beanDefinition;
            Set<String> initializerBeanNames = this.detectInitializerBeanNames(beanFactory);
            if (initializerBeanNames.isEmpty()) {
                return;
            }
            String previousInitializerBeanName = null;
            for (String initializerBeanName : initializerBeanNames) {
                beanDefinition = DependsOnDatabaseInitializationPostProcessor.getBeanDefinition(initializerBeanName, beanFactory);
                beanDefinition.setDependsOn(this.merge(beanDefinition.getDependsOn(), previousInitializerBeanName));
                previousInitializerBeanName = initializerBeanName;
            }
            for (String dependsOnInitializationBeanNames : this.detectDependsOnInitializationBeanNames(beanFactory)) {
                beanDefinition = DependsOnDatabaseInitializationPostProcessor.getBeanDefinition(dependsOnInitializationBeanNames, beanFactory);
                beanDefinition.setDependsOn(this.merge(beanDefinition.getDependsOn(), initializerBeanNames));
            }
        }

        private String[] merge(String[] source, String additional) {
            return this.merge(source, additional != null ? Collections.singleton(additional) : Collections.emptySet());
        }

        private String[] merge(String[] source, Set<String> additional) {
            LinkedHashSet<String> result = new LinkedHashSet<String>(source != null ? Arrays.asList(source) : Collections.emptySet());
            result.addAll(additional);
            return StringUtils.toStringArray(result);
        }

        private Set<String> detectInitializerBeanNames(ConfigurableListableBeanFactory beanFactory) {
            List<DatabaseInitializerDetector> detectors = this.getDetectors(beanFactory, DatabaseInitializerDetector.class);
            LinkedHashSet<String> beanNames = new LinkedHashSet();
            for (DatabaseInitializerDetector detector : detectors) {
                for (String beanName : detector.detect(beanFactory)) {
                    BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                    beanDefinition.setAttribute(DatabaseInitializerDetector.class.getName(), detector.getClass().getName());
                    beanNames.add(beanName);
                }
            }
            beanNames = Collections.unmodifiableSet(beanNames);
            for (DatabaseInitializerDetector detector : detectors) {
                detector.detectionComplete(beanFactory, beanNames);
            }
            return beanNames;
        }

        private Collection<String> detectDependsOnInitializationBeanNames(ConfigurableListableBeanFactory beanFactory) {
            List<DependsOnDatabaseInitializationDetector> detectors = this.getDetectors(beanFactory, DependsOnDatabaseInitializationDetector.class);
            HashSet<String> beanNames = new HashSet<String>();
            for (DependsOnDatabaseInitializationDetector detector : detectors) {
                beanNames.addAll(detector.detect(beanFactory));
            }
            return beanNames;
        }

        private <T> List<T> getDetectors(ConfigurableListableBeanFactory beanFactory, Class<T> type) {
            List<String> names = SpringFactoriesLoader.loadFactoryNames(type, beanFactory.getBeanClassLoader());
            Instantiator instantiator = new Instantiator(type, availableParameters -> availableParameters.add(Environment.class, this.environment));
            return instantiator.instantiate(names);
        }

        private static BeanDefinition getBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
            try {
                return beanFactory.getBeanDefinition(beanName);
            }
            catch (NoSuchBeanDefinitionException ex) {
                BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
                if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                    return DependsOnDatabaseInitializationPostProcessor.getBeanDefinition(beanName, (ConfigurableListableBeanFactory)parentBeanFactory);
                }
                throw ex;
            }
        }
    }
}

