/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.CollectionUtils;

final class BindConverter {
    private static BindConverter sharedInstance;
    private final List<ConversionService> delegates;

    private BindConverter(List<ConversionService> conversionServices, Consumer<PropertyEditorRegistry> propertyEditorInitializer) {
        ArrayList<ConversionService> delegates = new ArrayList<ConversionService>();
        delegates.add(new TypeConverterConversionService(propertyEditorInitializer));
        boolean hasApplication = false;
        if (!CollectionUtils.isEmpty(conversionServices)) {
            for (ConversionService conversionService : conversionServices) {
                delegates.add(conversionService);
                hasApplication = hasApplication || conversionService instanceof ApplicationConversionService;
            }
        }
        if (!hasApplication) {
            delegates.add(ApplicationConversionService.getSharedInstance());
        }
        this.delegates = Collections.unmodifiableList(delegates);
    }

    boolean canConvert(Object source, ResolvableType targetType, Annotation ... targetAnnotations) {
        return this.canConvert(TypeDescriptor.forObject(source), new ResolvableTypeDescriptor(targetType, targetAnnotations));
    }

    private boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (ConversionService service : this.delegates) {
            if (!service.canConvert(sourceType, targetType)) continue;
            return true;
        }
        return false;
    }

    <T> T convert(Object source, Bindable<T> target) {
        return this.convert(source, target.getType(), target.getAnnotations());
    }

    <T> T convert(Object source, ResolvableType targetType, Annotation ... targetAnnotations) {
        if (source == null) {
            return null;
        }
        return (T)this.convert(source, TypeDescriptor.forObject(source), new ResolvableTypeDescriptor(targetType, targetAnnotations));
    }

    private Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (int i2 = 0; i2 < this.delegates.size() - 1; ++i2) {
            try {
                ConversionService delegate = this.delegates.get(i2);
                if (!delegate.canConvert(sourceType, targetType)) continue;
                return delegate.convert(source, sourceType, targetType);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        return this.delegates.get(this.delegates.size() - 1).convert(source, sourceType, targetType);
    }

    static BindConverter get(List<ConversionService> conversionServices, Consumer<PropertyEditorRegistry> propertyEditorInitializer) {
        boolean sharedApplicationConversionService;
        boolean bl = sharedApplicationConversionService = conversionServices == null || conversionServices.size() == 1 && conversionServices.get(0) == ApplicationConversionService.getSharedInstance();
        if (propertyEditorInitializer == null && sharedApplicationConversionService) {
            return BindConverter.getSharedInstance();
        }
        return new BindConverter(conversionServices, propertyEditorInitializer);
    }

    private static BindConverter getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new BindConverter(null, null);
        }
        return sharedInstance;
    }

    private static class TypeConverterConverter
    implements ConditionalGenericConverter {
        private static final Set<Class<?>> EXCLUDED_EDITORS;
        private final SimpleTypeConverter typeConverter;

        TypeConverterConverter(SimpleTypeConverter typeConverter) {
            this.typeConverter = typeConverter;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Object.class));
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.getPropertyEditor(targetType.getType()) != null;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            SimpleTypeConverter typeConverter = this.typeConverter;
            return typeConverter.convertIfNecessary(source, targetType.getType());
        }

        private PropertyEditor getPropertyEditor(Class<?> type) {
            if (type == null || type == Object.class || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
                return null;
            }
            SimpleTypeConverter typeConverter = this.typeConverter;
            PropertyEditor editor = typeConverter.getDefaultEditor(type);
            if (editor == null) {
                editor = typeConverter.findCustomEditor(type, null);
            }
            if (editor == null && String.class != type) {
                editor = BeanUtils.findEditorByConvention(type);
            }
            if (editor == null || EXCLUDED_EDITORS.contains(editor.getClass())) {
                return null;
            }
            return editor;
        }

        static {
            HashSet<Class<FileEditor>> excluded = new HashSet<Class<FileEditor>>();
            excluded.add(FileEditor.class);
            EXCLUDED_EDITORS = Collections.unmodifiableSet(excluded);
        }
    }

    private static class TypeConverterConversionService
    extends GenericConversionService {
        TypeConverterConversionService(Consumer<PropertyEditorRegistry> initializer) {
            this.addConverter(new TypeConverterConverter(this.createTypeConverter(initializer)));
            ApplicationConversionService.addDelimitedStringConverters(this);
        }

        private SimpleTypeConverter createTypeConverter(Consumer<PropertyEditorRegistry> initializer) {
            SimpleTypeConverter typeConverter = new SimpleTypeConverter();
            if (initializer != null) {
                initializer.accept(typeConverter);
            }
            return typeConverter;
        }

        @Override
        public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (targetType.isArray() && targetType.getElementTypeDescriptor().isPrimitive()) {
                return false;
            }
            return super.canConvert(sourceType, targetType);
        }
    }

    private static class ResolvableTypeDescriptor
    extends TypeDescriptor {
        ResolvableTypeDescriptor(ResolvableType resolvableType, Annotation[] annotations) {
            super(resolvableType, null, annotations);
        }
    }
}

