/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloud;

import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public enum CloudPlatform {
    NONE{

        @Override
        public boolean isDetected(Environment environment2) {
            return false;
        }
    }
    ,
    CLOUD_FOUNDRY{

        @Override
        public boolean isDetected(Environment environment2) {
            return environment2.containsProperty("VCAP_APPLICATION") || environment2.containsProperty("VCAP_SERVICES");
        }
    }
    ,
    HEROKU{

        @Override
        public boolean isDetected(Environment environment2) {
            return environment2.containsProperty("DYNO");
        }
    }
    ,
    SAP{

        @Override
        public boolean isDetected(Environment environment2) {
            return environment2.containsProperty("HC_LANDSCAPE");
        }
    }
    ,
    KUBERNETES{
        private static final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
        private static final String KUBERNETES_SERVICE_PORT = "KUBERNETES_SERVICE_PORT";
        private static final String SERVICE_HOST_SUFFIX = "_SERVICE_HOST";
        private static final String SERVICE_PORT_SUFFIX = "_SERVICE_PORT";

        @Override
        public boolean isDetected(Environment environment2) {
            if (environment2 instanceof ConfigurableEnvironment) {
                return this.isAutoDetected((ConfigurableEnvironment)environment2);
            }
            return false;
        }

        private boolean isAutoDetected(ConfigurableEnvironment environment2) {
            PropertySource<?> environmentPropertySource = environment2.getPropertySources().get("systemEnvironment");
            if (environmentPropertySource != null) {
                if (environmentPropertySource.containsProperty(KUBERNETES_SERVICE_HOST) && environmentPropertySource.containsProperty(KUBERNETES_SERVICE_PORT)) {
                    return true;
                }
                if (environmentPropertySource instanceof EnumerablePropertySource) {
                    return this.isAutoDetected((EnumerablePropertySource)environmentPropertySource);
                }
            }
            return false;
        }

        private boolean isAutoDetected(EnumerablePropertySource<?> environmentPropertySource) {
            for (String propertyName : environmentPropertySource.getPropertyNames()) {
                String serviceName;
                if (!propertyName.endsWith(SERVICE_HOST_SUFFIX) || environmentPropertySource.getProperty((serviceName = propertyName.substring(0, propertyName.length() - SERVICE_HOST_SUFFIX.length())) + SERVICE_PORT_SUFFIX) == null) continue;
                return true;
            }
            return false;
        }
    }
    ,
    AZURE_APP_SERVICE{
        private static final String WEBSITE_SITE_NAME = "WEBSITE_SITE_NAME";
        private static final String WEBSITES_ENABLE_APP_SERVICE_STORAGE = "WEBSITES_ENABLE_APP_SERVICE_STORAGE";

        @Override
        public boolean isDetected(Environment environment2) {
            return environment2.containsProperty(WEBSITE_SITE_NAME) && environment2.containsProperty(WEBSITES_ENABLE_APP_SERVICE_STORAGE);
        }
    };

    private static final String PROPERTY_NAME = "spring.main.cloud-platform";

    public boolean isActive(Environment environment2) {
        String platformProperty = environment2.getProperty(PROPERTY_NAME);
        return this.isEnforced(platformProperty) || platformProperty == null && this.isDetected(environment2);
    }

    public boolean isEnforced(Environment environment2) {
        return this.isEnforced(environment2.getProperty(PROPERTY_NAME));
    }

    public boolean isEnforced(Binder binder) {
        return this.isEnforced((String)binder.bind(PROPERTY_NAME, String.class).orElse(null));
    }

    private boolean isEnforced(String platform) {
        return this.name().equalsIgnoreCase(platform);
    }

    public abstract boolean isDetected(Environment var1);

    public boolean isUsingForwardHeaders() {
        return true;
    }

    public static CloudPlatform getActive(Environment environment2) {
        if (environment2 != null) {
            for (CloudPlatform cloudPlatform : CloudPlatform.values()) {
                if (!cloudPlatform.isActive(environment2)) continue;
                return cloudPlatform;
            }
        }
        return null;
    }
}

