/*
 * Decompiled with CFR 0.152.
 */
package com.value_medical.optimate;

import com.value_medical.optimate.App;
import com.value_medical.optimate.AppProperties;
import com.value_medical.optimate.MonitoredFileStream;
import com.value_medical.optimate.ProgressMonitor;
import com.value_medical.optimate.UploadJob;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UploadTask
implements Runnable {
    @Value(value="${app.max-retries:10}")
    private int maxRetries;
    @Value(value="${app.max-delay:60000}")
    private int maxDelay;
    private final Logger logger;
    private final App app;
    private final AppProperties properties;
    private final ProgressMonitor monitor;
    private Exception error = null;

    public UploadTask(App app, Logger logger, AppProperties properties) {
        this.app = app;
        this.logger = logger;
        this.monitor = app.getMonitor();
        this.properties = properties;
    }

    private CloseableHttpClient getHttpClient() {
        if (this.properties.isTrustSelfSigned()) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (hostname, session) -> true);
                Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", sslConnectionSocketFactory).build();
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
                return HttpClients.custom().setConnectionManager(connectionManager).build();
            }
            catch (Exception ex) {
                this.logger.warn("Failed to build http client trusting self-signed certificates: " + ex);
            }
        }
        this.logger.info("Using default http client");
        return HttpClients.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (CloseableHttpClient client = this.getHttpClient();){
            UploadJob job;
            while ((job = this.app.getNextJob()) != null) {
                this.logger.debug("file: " + job.getFile().getAbsolutePath());
                String mimeType = Files.probeContentType(job.getFile().toPath());
                if (mimeType == null) {
                    mimeType = "application/octet-stream";
                }
                this.logger.debug("content type: " + mimeType);
                ContentType contentType = ContentType.create(mimeType);
                int retries = 0;
                while (true) {
                    try {
                        this.uploadFile(client, job, contentType);
                    }
                    catch (Exception ex) {
                        if (++retries > this.maxRetries) {
                            throw ex;
                        }
                        long millis = Math.min((long)this.maxDelay, (long)(Math.pow(1.618, retries) * 1000.0));
                        this.logger.info("upload failed, retrying in " + millis / 1000L + " seconds");
                        Thread.sleep(millis);
                        continue;
                    }
                    break;
                }
                this.app.skipJob();
            }
        }
        catch (Exception ex) {
            this.error = ex;
        }
        finally {
            this.app.taskDone(this);
        }
    }

    private void uploadFile(CloseableHttpClient client, UploadJob job, ContentType contentType) throws IOException {
        File file = job.getFile();
        InputStreamEntity reqEntity = new InputStreamEntity(new MonitoredFileStream(file, this.monitor), file.length(), contentType);
        HttpPost request = new HttpPost(job.getUploadURL());
        request.addHeader("X-Original-Filename", file.getName());
        request.addHeader("Authorization", "Bearer " + job.getUploadToken());
        request.setEntity(reqEntity);
        try (CloseableHttpResponse response = client.execute(request);){
            if (response.getCode() != 201) {
                byte[] body2 = response.getEntity().getContent().readAllBytes();
                throw new RuntimeException(String.format("upload failed, %s (%d): %s", response.getReasonPhrase(), response.getCode(), new String(body2)));
            }
            try {
                String location = response.getHeader("Location").getValue();
            }
            catch (ProtocolException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Exception getError() {
        return this.error;
    }
}

