/*
 * Decompiled with CFR 0.152.
 */
package com.value_medical.optimate;

import com.value_medical.optimate.ProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;

public class MonitoredFileStream
extends FilterInputStream {
    private final ProgressMonitor monitor;
    private final long size;
    private long numRead = 0L;
    private int lastReported = 0;

    public MonitoredFileStream(File file, ProgressMonitor monitor) throws IOException {
        super(new FileInputStream(file));
        this.size = file.length();
        this.monitor = monitor;
    }

    private void report() throws InterruptedIOException {
        int percent = (int)Math.round((double)this.numRead * 100.0 / (double)this.size);
        if (percent != this.lastReported) {
            this.monitor.setProgress(percent);
            this.lastReported = percent;
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = (int)this.numRead;
            throw exc;
        }
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            ++this.numRead;
        }
        this.report();
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        this.numRead += (long)nr;
        this.report();
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        this.numRead += (long)nr;
        this.report();
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        this.numRead += nr;
        this.report();
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.monitor.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.numRead = this.size - (long)this.in.available();
        this.report();
    }
}

