/*
 * Decompiled with CFR 0.152.
 */
package com.value_medical.optimate;

import com.value_medical.optimate.App;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class ListTransferHandler
extends TransferHandler {
    private final App app;

    public ListTransferHandler(App app) {
        this.app = app;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        return this.app.allowImport() && info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        List files;
        if (!info.isDrop()) {
            return false;
        }
        JList list = (JList)info.getComponent();
        DefaultListModel listModel = (DefaultListModel)list.getModel();
        JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
        int index = dl.getIndex();
        if (!dl.isInsert()) {
            return false;
        }
        Transferable t = info.getTransferable();
        try {
            files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (Exception e) {
            return false;
        }
        LinkedList expandedFiles = new LinkedList();
        for (File f : files) {
            try {
                Files.find(f.toPath(), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]).forEach(file -> expandedFiles.add(file.toFile()));
            }
            catch (IOException iOException) {}
        }
        for (File f : expandedFiles) {
            listModel.add(index++, f);
        }
        return true;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
    }
}

