/*
 * Decompiled with CFR 0.152.
 */
package com.value_medical.optimate;

import com.value_medical.optimate.App;
import java.util.Optional;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class AppController {
    private final App app;

    public AppController(App app) {
        this.app = app;
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception e) {
                System.out.println("Failed to initialize UI: " + e);
            }
            JFrame frame = new JFrame("OptiMate");
            frame.setDefaultCloseOperation(3);
            frame.setContentPane(app.getContentPane());
            frame.pack();
            frame.setVisible(true);
        });
    }

    @PostMapping(path={"/select"}, consumes={"application/x-www-form-urlencoded", "multipart/form-data"})
    @CrossOrigin
    @ResponseBody
    public String selectEndpoint(@RequestParam Optional<String> targetUUID, @RequestParam Optional<String> targetPath, @RequestParam String targetTitle, @RequestParam String uploadURL, @RequestParam String uploadToken) {
        Object path;
        if (targetPath.isPresent()) {
            path = targetPath.get();
        } else if (targetUUID.isPresent()) {
            path = "documents/" + targetUUID.get();
        } else {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "targetUUID or targetPath is required");
        }
        this.app.select((String)path, targetTitle, uploadURL, uploadToken);
        return "OK";
    }
}

