/*
 * Decompiled with CFR 0.152.
 */
package com.value_medical.optimate;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.value_medical.optimate.ImageFileFilter;
import com.value_medical.optimate.ListTransferHandler;
import com.value_medical.optimate.ProgressMonitor;
import com.value_medical.optimate.UploadJob;
import com.value_medical.optimate.UploadTask;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class App {
    private JList<File> list1;
    private JPanel contentPane;
    private JButton uploadButton;
    private JTabbedPane tabbedPane1;
    private JProgressBar fileProgress;
    private JProgressBar overallProgress;
    private JLabel overallLabel;
    private JLabel fileLabel;
    private JLabel targetLabel;
    private JLabel filePathLabel;
    private JLabel prepareTargetLabel;
    private JButton clearButton;
    private JButton startButton;
    private JButton addButton;
    private final ReadWriteLock lock;
    private final List<UploadJob> jobs;
    private int currentJobIndex;
    private String targetPath;
    private String targetTitle;
    private String uploadURL;
    private String uploadToken;
    private boolean uploading;

    public App(ApplicationContext context, TaskExecutor taskExecutor) {
        this.$$$setupUI$$$();
        this.lock = new ReentrantReadWriteLock();
        this.jobs = new ArrayList<UploadJob>();
        this.currentJobIndex = 0;
        this.targetPath = null;
        this.targetTitle = null;
        this.uploadURL = null;
        this.uploadToken = null;
        this.uploading = false;
        final DefaultListModel fileList = new DefaultListModel();
        this.contentPane.setOpaque(true);
        this.list1.setModel(fileList);
        ListTransferHandler handler = new ListTransferHandler(this);
        this.list1.setTransferHandler(handler);
        this.list1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int[] selection = App.this.list1.getSelectedIndices();
                    for (int index = selection.length - 1; index >= 0; --index) {
                        fileList.remove(selection[index]);
                    }
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.uploadButton.addActionListener(e -> {
            ArrayList<File> files = Collections.list(fileList.elements());
            fileList.removeAllElements();
            this.lock.writeLock().lock();
            if (!files.isEmpty()) {
                try {
                    for (File file : files) {
                        this.jobs.add(new UploadJob(this.targetTitle, this.targetPath, file, this.uploadURL, this.uploadToken));
                    }
                    this.updateLabels();
                    if (!this.uploading) {
                        taskExecutor.execute(context.getBean(UploadTask.class));
                        this.uploading = true;
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                this.tabbedPane1.setSelectedIndex(1);
                this.updateLabels();
            }
        });
        this.startButton.addActionListener(e -> {
            this.lock.writeLock().lock();
            try {
                if (!this.uploading) {
                    taskExecutor.execute(context.getBean(UploadTask.class));
                    this.uploading = true;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            this.updateLabels();
        });
        this.clearButton.addActionListener(e -> {
            this.lock.writeLock().lock();
            try {
                this.jobs.clear();
                this.currentJobIndex = 0;
            }
            finally {
                this.lock.writeLock().unlock();
            }
            this.updateLabels();
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setMultiSelectionEnabled(true);
                fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                ImageFileFilter filter2 = new ImageFileFilter();
                fileChooser.addChoosableFileFilter(filter2);
                fileChooser.setFileFilter(filter2);
                int result = fileChooser.showOpenDialog(App.this.getContentPane());
                if (result == 0) {
                    File[] selectedFiles;
                    for (File file : selectedFiles = fileChooser.getSelectedFiles()) {
                        fileList.addElement(file);
                    }
                }
            }
        });
    }

    public void select(String targetPath, String targetTitle, String uploadURL, String uploadToken) {
        this.lock.writeLock().lock();
        this.targetPath = targetPath;
        this.targetTitle = targetTitle;
        this.uploadURL = uploadURL;
        this.uploadToken = uploadToken;
        this.lock.writeLock().unlock();
        SwingUtilities.invokeLater(this::updateLabels);
    }

    public ProgressMonitor getMonitor() {
        return new ProgressMonitor(){

            @Override
            public boolean isCanceled() {
                return false;
            }

            @Override
            public void setProgress(int percent) {
                SwingUtilities.invokeLater(() -> App.this.fileProgress.setValue(percent));
            }

            @Override
            public void close() {
            }
        };
    }

    public void taskDone(UploadTask task) {
        if (task.getError() != null) {
            task.getError().printStackTrace();
        }
        this.lock.writeLock().lock();
        this.uploading = false;
        this.lock.writeLock().unlock();
        SwingUtilities.invokeLater(this::updateLabels);
    }

    public boolean allowImport() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.targetPath != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void updateLabels() {
        this.lock.readLock().lock();
        try {
            this.prepareTargetLabel.setText(this.targetTitle == null ? "PAS DE DESTINATION S\u00c9LECTIONN\u00c9E" : this.targetTitle);
            this.overallLabel.setText(String.format("%d/%d", this.currentJobIndex, this.jobs.size()));
            this.overallProgress.setMaximum(this.jobs.size());
            this.overallProgress.setValue(this.currentJobIndex);
            if (this.currentJobIndex < this.jobs.size()) {
                this.jobs.get(this.currentJobIndex).report(this);
            } else {
                this.targetLabel.setText("");
                this.filePathLabel.setText("");
            }
            this.startButton.setEnabled(!this.uploading);
            this.uploadButton.setEnabled(this.uploadToken != null);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void reportCurrentJob(String target, File file) {
        this.targetLabel.setText(target);
        this.filePathLabel.setText(file.getName());
    }

    public UploadJob getNextJob() {
        this.lock.writeLock().lock();
        try {
            UploadJob uploadJob = this.currentJobIndex < this.jobs.size() ? this.jobs.get(this.currentJobIndex) : null;
            return uploadJob;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void skipJob() {
        this.lock.writeLock().lock();
        ++this.currentJobIndex;
        if (this.currentJobIndex == this.jobs.size()) {
            this.jobs.clear();
            this.currentJobIndex = 0;
        }
        this.lock.writeLock().unlock();
        SwingUtilities.invokeLater(this::updateLabels);
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public String getUploadURL() {
        return this.uploadURL;
    }

    public String getUploadToken() {
        return this.uploadToken;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JLabel jLabel;
        JLabel jLabel2;
        JProgressBar jProgressBar;
        JLabel jLabel3;
        JProgressBar jProgressBar2;
        JLabel jLabel4;
        JButton jButton3;
        JLabel jLabel5;
        JButton jButton4;
        JTabbedPane jTabbedPane;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.tabbedPane1 = jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Pr\u00e9paration", null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, new Dimension(100, 100), new Dimension(400, 300), null));
        JList jList = new JList();
        this.list1 = jList;
        jList.setDropMode(DropMode.INSERT);
        ((Component)jList).setForeground(new Color(-4473925));
        jList.putClientProperty("List.isFileList", Boolean.TRUE);
        jScrollPane.setViewportView(jList);
        this.uploadButton = jButton4 = new JButton();
        ((Component)jButton4).setEnabled(false);
        jButton4.setText("Upload");
        jPanel2.add((Component)jButton4, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.prepareTargetLabel = jLabel5 = new JLabel();
        jLabel5.setHorizontalAlignment(0);
        jLabel5.setHorizontalTextPosition(0);
        jLabel5.setText("PAS DE DESTINATION S\u00c9LECTIONN\u00c9E");
        jPanel2.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.addButton = jButton3 = new JButton();
        jButton3.setText("Add...");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(7, 3, new Insets(20, 20, 20, 20), 10, 10, false, false));
        jTabbedPane.addTab("Transfert", null, jPanel4, null);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Destination");
        jPanel4.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.targetLabel = jLabel4 = new JLabel();
        jLabel4.setText("(document title)");
        jPanel4.add((Component)jLabel4, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.overallProgress = jProgressBar2 = new JProgressBar();
        jPanel4.add((Component)jProgressBar2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Fichier");
        jPanel4.add((Component)jLabel7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.filePathLabel = jLabel3 = new JLabel();
        jLabel3.setText("(path)");
        jPanel4.add((Component)jLabel3, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, 14, jLabel8.getFont());
        if (font != null) {
            jLabel8.setFont(font);
        }
        jLabel8.setText("Fichiers en attente");
        jPanel4.add((Component)jLabel8, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, 1, 14, jLabel9.getFont());
        if (font2 != null) {
            jLabel9.setFont(font2);
        }
        jLabel9.setText("Fichier en cours");
        jPanel4.add((Component)jLabel9, new GridConstraints(2, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.fileProgress = jProgressBar = new JProgressBar();
        jPanel4.add((Component)jProgressBar, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.overallLabel = jLabel2 = new JLabel();
        jLabel2.setText("0/0");
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.fileLabel = jLabel = new JLabel();
        jLabel.setText("0/0");
        jPanel4.add((Component)jLabel, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(3, 1, new Insets(20, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(6, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.clearButton = jButton2 = new JButton();
        jButton2.setText("Clear");
        jPanel5.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.startButton = jButton = new JButton();
        jButton.setText("Start");
        jPanel5.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

